"""
LetMeDoIt AI Plugin - ask chatgpt

Ask ChatGPT for conversation only; no function calling

[FUNCTION_CALL]
"""


from taskwiz import config
from taskwiz.chatgpt import ChatGPT

def ask_chatgpt(function_args):
    config.stopSpinning()
    query = function_args.get("query") # required
    config.currentMessages = config.currentMessages[:-1]
    ChatGPT().run(query)
    return ""

functionSignature = {
    "name": "ask_chatgpt",
    "description": "Ask ChatGPT to chat or provide information",
    "parameters": {
        "type": "object",
        "properties": {
            "query": {
                "type": "string",
                "description": "The original request in detail, including any supplementary information",
            },
        },
        "required": ["query"],
    },
}

config.pluginsWithFunctionCall.append("ask_chatgpt")
config.chatGPTApiFunctionSignatures.append(functionSignature)
config.chatGPTApiAvailableFunctions["ask_chatgpt"] = ask_chatgpt
config.inputSuggestions.append("Ask ChatGPT: ")